import flask
import httplib

from sandbox import common

from sandbox.yasandbox import controller


__all__ = ("init_plugin",)

bp = flask.Blueprint("health_check", __name__)


class NullResponse(flask.Response):
    def __call__(self, environ, start_response):
        yield None


@bp.route("/health_check")
def health_check(path=None):
    """ Lightweight http check for balancer """
    state = controller.State.get(common.config.Registry().this.id)
    if state is not None and not state.api_enabled:
        return "Api turned off", httplib.INTERNAL_SERVER_ERROR
    return "", httplib.OK


def init_plugin(app):
    app.register_blueprint(bp)
