import flask
import httplib

import sandbox.common.types.database as ctd

from sandbox.serviceapi import metrics
from sandbox.serviceapi import constants as sa_consts

from sandbox.yasandbox import context
from sandbox.yasandbox.database import mapping as mp

from sandbox.serviceapi.web import routes


__all__ = ("init_plugin",)


# https://a.yandex-team.ru/arc/trunk/arcadia/contrib/python/uwsgi/uwsgi.h?rev=3345147#L1172
UWSGI_ROUTE_BREAK = 2

bp = flask.Blueprint("http_check", __name__)


class NullResponse(flask.Response):
    def __call__(self, environ, start_response):
        yield None


@bp.route("/http_check")
def http_check(path=None):
    """ Heavy http check for monitoring """
    try:
        conn = mp.get_connection(ctd.ReadPreference.SECONDARY)
        conn.admin.command("ping")
    except Exception:
        return "", httplib.INTERNAL_SERVER_ERROR

    import uwsgi
    retv = uwsgi.route(sa_consts.LegacyAPI.schema, ":{}".format(sa_consts.LegacyAPI.port))

    if retv != UWSGI_ROUTE_BREAK:
        context.current.logger.error("uwsgi.route() returned unexpected value: %s", retv)
    metrics.rate_inc("legacy_requests")
    return NullResponse()


def init_plugin(app):
    routes.apply_max_concurrent_requests_guard(bp)
    app.register_blueprint(bp)
