import textwrap

import flask

from sandbox.web import api


__all__ = ("init_plugin",)


openapi_bp = flask.Blueprint("redoc", __name__)


@openapi_bp.route("/api/v1.0/swagger.json")
def swagger_json():
    return flask.jsonify(api.v1.Api.dict)


@openapi_bp.route("/api/redoc")
def redoc():
    return textwrap.dedent("""
        <!DOCTYPE html>
        <html>
          <head>
            <title>ReDoc</title>
            <!-- needed for adaptive design -->
            <meta charset="utf-8"/>
            <meta name="viewport" content="width=device-width, initial-scale=1">

            <!--
            ReDoc doesn't change outer page styles
            -->
            <style>
              body {
                margin: 0;
                padding: 0;
              }
            </style>
          </head>
          <body>
            <redoc suppress-warnings spec-url="/api/v1.0/swagger.json"></redoc>
            <script src="/media/redoc/redoc.min.js"> </script>
          </body>
        </html>
    """)


def init_plugin(app):
    app.register_blueprint(openapi_bp)
