import time
import flask

from sandbox.serviceapi import metrics


__all__ = ("init_plugin",)


request_latency = metrics.Histogram("request_latency", buckets=20)


def request_method():
    return "{} [{}]".format(flask.request.url_rule.rule, flask.request.method)


def before_request():
    flask.g.request_started = time.time()


def teardown_request(exception=None):
    if getattr(flask.request, "rejected", False):
        # Don't count stats for rejected requests
        return

    request_latency.record(int((time.time() - flask.g.request_started) * 1000))  # Convert to milliseconds

    metrics.rate_inc("processed_requests")
    metrics.rate_inc("processed_requests", labels={"method": request_method()})


def init_plugin(app):
    app.before_request(before_request)
    app.teardown_request(teardown_request)
