import os
import httplib
import StringIO

import flask

from sandbox.common import config


__all__ = ("init_plugin",)


registry = config.Registry()


media_bp = flask.Blueprint("media", __name__)


@media_bp.route("/media/<path:filename>")
def files(filename):
    filename = filename.strip("/")
    if filename == "swagger-ui":
        return flask.redirect("/media/swagger-ui/index.html", code=httplib.MOVED_PERMANENTLY)

    from library.python import resource
    data = resource.find("sandbox/web/media/" + filename)
    if data is None:
        return flask.abort(httplib.NOT_FOUND)

    fileobj = StringIO.StringIO(data)
    return flask.send_file(fileobj, attachment_filename=filename, add_etags=False)


docs_bp = flask.Blueprint(
    "docs", __name__,
    static_folder=os.path.join(registry.server.web.static.docs_link),
    static_url_path="/docs"
)


def init_plugin(app):
    app.register_blueprint(media_bp)
    app.register_blueprint(docs_bp)
