import threading

import flask

from sandbox.serviceapi import constants
from sandbox.serviceapi.web import routes, exceptions
from sandbox.yasandbox import context


try:
    import uwsgi
except ImportError:
    uwsgi = None


__all__ = ("init_plugin",)


# Thread-local for requests session to MDS storage
tls = threading.local()
tls.session = None


bp = flask.Blueprint("versions", __name__)


@bp.route(constants.Path.NOT_IMPLEMENTED_URL, accept_all_methods=True)
def versions_handler(version, path=None):
    context.current.logger.info("Current version: %s", version)
    raise exceptions.NotFound("Method not implemented")


def init_plugin(app):
    routes.apply_max_concurrent_requests_guard(bp)
    bp.before_request(routes.before_request)
    bp.errorhandler(exceptions.HttpError)(routes.http_error_handler)
    bp.after_request(routes.after_request)
    app.register_blueprint(bp)
