import functools
import time

import sandbox.serviceq.client


__all__ = ("install_tracker", "register_event_handler")


class OriginalMethods(object):
    _rpc_call = sandbox.serviceq.client.Client._rpc_call


_event_handlers = []


def install_tracker():
    if sandbox.serviceq.client.Client._rpc_call != _rpc_call:
        sandbox.serviceq.client.Client._rpc_call = _rpc_call


def register_event_handler(func):
    _event_handlers.append(func)


# Generic event handler, user can register their own handler via `register_event_handler`
def send_event(event):
    for func in _event_handlers:
        func(event)


# Wrap Client._rpc_call
@functools.wraps(OriginalMethods._rpc_call)
def _rpc_call(client_self, method_name, *args, **kwargs):
    start_time = time.time()
    result = OriginalMethods._rpc_call(
        client_self, method_name,
        *args, **kwargs
    )
    total_time = time.time() - start_time

    send_event({
        "type": "_rpc_call",
        "method": method_name,
        "time": total_time,
    })
    return result
