from sandbox.yasandbox import context
from sandbox.serviceapi import trackers

from . import routes
from . import aggregator


__all__ = ("init_api", "RouteV1", "RouteV2", "QuotaManagementRouteV1")


SERVICEQ_UNTRACKING_METHODS = ["push_api_quota"]  # no counted serviceq methods


class RouteV1(routes.Route):
    version = "1.0"  # legacy route


class RouteV2(routes.Route):
    version = "2"


class QuotaManagementRouteV1(routes.Route):
    version = "1"
    path_prefix = "quotaManagement"


def init_api(app):
    aggregator.Aggregator().start()
    for url_prefix, bp in routes.blueprints.items():
        app.register_blueprint(bp, url_prefix=url_prefix)

    # Patch pymongo to enable event collection
    def mongodb_event_handler(event):
        context.current.add_span("mongodb_op", event.pop("time"), event)

    trackers.mongodb.install_tracker()
    trackers.mongodb.register_event_handler(mongodb_event_handler)

    # Patch serviceq.client to enable event collection
    def serviceq_event_handler(event):
        if event.get("method") not in SERVICEQ_UNTRACKING_METHODS:
            context.current.add_span("serviceq_call", event.pop("time"), event)

    trackers.serviceq.install_tracker()
    trackers.serviceq.register_event_handler(serviceq_event_handler)
