PROGRAM(serviceapi)

OWNER(g:sandbox-dev)

PEERDIR(
    library/python/svn_version

    contrib/python/aniso8601
    contrib/python/botocore
    contrib/python/Flask
    contrib/python/flask-cors
    contrib/python/paramiko
    contrib/python/PyYAML
    contrib/python/requests
    contrib/python/uwsgi
    contrib/python/Werkzeug

    sandbox/common
    sandbox/etc
    sandbox/serviceq
    sandbox/web/api
    sandbox/yasandbox/api/json/mappers
    sandbox/yasandbox/context
    sandbox/yasandbox/controller
    sandbox/yasandbox/database

    sandbox/serviceapi/constants
    sandbox/serviceapi/metrics
    sandbox/serviceapi/mules
    sandbox/serviceapi/plugins
    sandbox/serviceapi/trackers
    sandbox/serviceapi/web

    sandbox/sdk2

    sandbox/taskbox/model
)

RESOURCE(
    uwsgi.yaml serviceapi/uwsgi.yaml
)

PY_SRCS(
    __init__.py
    __main__.py
    app.py
    wsgi.py

    handlers/authenticate.py
    handlers/__init__.py
    handlers/client.py
    handlers/common.py
    handlers/group.py
    handlers/notification.py
    handlers/task.py
    handlers/template.py
    handlers/resource.py
    handlers/scheduler.py
    handlers/semaphore.py
    handlers/service.py
    handlers/statistics.py
    handlers/suggest.py
    handlers/user.py
    handlers/vault.py
    handlers/yav.py

    handlers/quota_management/__init__.py
    handlers/quota_management/accounts.py
    handlers/quota_management/blueprints/__init__.py
    handlers/quota_management/blueprints/v1/__init__.py
    handlers/quota_management/blueprints/v1/api.py
    handlers/quota_management/blueprints/v1/account.py
    handlers/quota_management/blueprints/v1/schemas/__init__.py
    handlers/quota_management/blueprints/v1/schemas/account.py
    handlers/quota_management/blueprints/v1/schemas/common.py
    handlers/quota_management/blueprints/v1/schemas/provision.py
    handlers/quota_management/blueprints/v1/schemas/resource.py

    mappers/__init__.py
    mappers/client.py
    mappers/group.py
    mappers/notification.py
    mappers/resource.py
    mappers/scheduler.py
    mappers/semaphore.py
    mappers/task.py
    mappers/vault.py
)

END()

RECURSE(
    metrics
    mules
    plugins
    trackers
    constants
    web
)

RECURSE_FOR_TESTS(
    tests
)
