import gc
import os
import sys
import signal
import logging

SANDBOX_DIR = reduce(lambda p, _: os.path.dirname(p), xrange(3), os.path.abspath(__file__))
sys.path[:0] = [os.path.dirname(SANDBOX_DIR), SANDBOX_DIR]

from sandbox import common
common.import_hook.setup_sandbox_namespace()

import sandbox.common.types.misc as ctm
import sandbox.common.joint.client as jclient

import sandbox.serviceq.server as qserver
import sandbox.serviceq.client as qclient
import sandbox.serviceq.config as qconfig

from sandbox.yasandbox.database import mapping


def run(config):
    qclient.Client.RPCClient = jclient.RPCClientGevent
    server = qserver.Server(config)
    for sig in (signal.SIGINT, signal.SIGTERM):
        signal.signal(sig, lambda *args: setattr(server, "_stopping", True))
    signal.signal(signal.SIGUSR2, lambda *_: common.threading.dump_greenlet_threads())
    server.start()
    try:
        server.loop()
    except KeyboardInterrupt:
        server.stop()


def main():
    common.config.ensure_local_settings_defined(qconfig.Registry.CONFIG_ENV_VAR)
    config = qconfig.Registry()
    # setup logging
    log_path = os.path.join(config.serviceq.log.root, config.serviceq.log.name)
    mapping.ensure_connection(
        uri=config.serviceq.server.mongodb.connection_url,
        max_pool_size=config.serviceq.server.mongodb.max_pool_size
    )
    logger = common.log.setup_log(
        log_path if config.common.installation in ctm.Installation.Group.LOCAL else logging.FileHandler(log_path),
        config.serviceq.log.level
    )
    common.statistics.Signaler(
        common.statistics.ServerSignalHandler(config=config),
        logger=logger,
        component=ctm.Component.SERVICEQ,
        config=config
    )
    gc.set_threshold(*config.serviceq.server.gc.python.threshold)
    run(config)


if __name__ == "__main__":
    main()
