import sandbox.common.joint.errors as joint_errors


class QException(Exception):
    """ Base class for internal exceptions of the Service Q """


class QAcquireError(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Raised when lock already acquired """


class QTimeout(QException):
    """ Raised when timeout of network communication is occurred """


class QRetry(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Used internally for retrying of requests to the server """


class QElectionInProgress(QRetry):
    """ Election of PRIMARY is in progress, try again later """


class QConflict(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Used in method pop for resolving of race conditions """


class QTaskConflict(QConflict):
    """ Task already popped from queue """


class QSemaphoreConflict(QConflict):
    """ Required semaphores are busy """


class QJobConflict(QConflict):
    """ Job already was started """


class QAlreadyExecuting(QConflict):
    """ Task already executing """


class QNeedValidation(QException, joint_errors.ServerError):
    """ Raised after unclean shutdown of Q server """


class QRedirect(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Used internally to redirect calls to the current master """


class QNotPrimary(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Raised when PRIMARY ceased to be PRIMARY """


class QOutdated(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Raised when snapshot is outdated """


class QSnapshotNotReady(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Raised when snapshot is making in another request, current request must be retried later """


class QSemaphoresTemporaryUnavailable(QException, joint_errors.SilentException, joint_errors.ServerError):
    """ Raised when semaphores are not yet restored from DB """
