cimport cython
from libcpp.string cimport string


cdef class Serializable:
    pass


cdef class TaskRef(Serializable):
    cdef public int __task_id


cdef class Execution:
    cdef:
        public string job_id
        public long start_time, finish_time, qp
        public int finished
        public long ram, cpu, hdd, ssd


cdef class Consumption(Serializable):
    cdef:
        public long __window_size, __consumed_qp, __entering_qp, __exiting_qp, __future_qp, __future_total_qp, __last_time
        public dict __executions
        public object __started_executions, __finished_executions
        public list __future_executions
        public long __ram, __cpu, __hdd, __ssd
        public list __usage_metrics

    # noinspection PyUnresolvedReferences
    @cython.locals(calc_interval=long, lower_bound=long, prev_lower_bound=long, execution=Execution, finish_time=long, lower_index=int)
    cpdef calculate(self, long now)

    cpdef started(self, long start_time, job_id, long qp, long duration, long ram, long cpu, long hdd, long ssd)

    # noinspection PyUnresolvedReferences
    @cython.locals(execution=Execution)
    cpdef finished(self, long finish_time, job_id)


cdef class HostQueueItem(Serializable):
    cdef:
        public float score
        public long task_id
        public TaskRef task_ref

    cpdef encode(self, int priority=*)
