from .client_availability_checker import ClientAvailabilityChecker
from .client_availability_manager import ClientAvailabilityManager
from .network_macros_resolver import NetworkMacrosResolver
from .client_processor import ClientProcessor
from .client_slots_monitor import ClientSlotsMonitor
from .resources_statistics import ResourcesStatistics
from .statistics_processor import StatisticsProcessor
from .task_queue_validator import TaskQueueValidator
from .task_status_notifier import TaskStatusNotifier
from .task_state_switcher import TaskStateSwitcher
from .task_status_checker import TaskStatusChecker
from .hosts_cache_updater import HostsCacheUpdater
from .update_robot_owners import UpdateRobotOwners
from .group_synchronizer import GroupSynchronizer
from .auto_restart_tasks import AutoRestartTasks
from .metrics_reporter import MetricsReporter
from .tasks_statistics import TasksStatistics
from .check_semaphores import CheckSemaphores
from .clean_resources import CleanResources
from .messengerq_bot import MessengerQBot
from .mongodb_reporter import MongoMonitor
from .mongodb_reporter import MongoChecker
from .tasks_enqueuer import TasksEnqueuer
from .cpu_balancer import CpuBalancer
from .telegram_bot import TelegramBot
from .scheduler import Scheduler
from .cleaner import Cleaner
from .mailman import Mailman
from .juggler import Juggler
from .mds_cleaner import MDSCleaner
from .mds_lru_cleaner import MdsLruCleaner
from .backup_resources import BackupResources
from .backup_resources import ReplicateResources
from .backup_resources import BackupResourcesToMds
from .backup_resources import CopyResourcesToWarehouse
from .task_tags_checker import TaskTagsChecker
from .logbroker_publisher import LogbrokerPublisher


service_registry = {
    service.name: service
    for service in (
        ClientAvailabilityChecker,
        ClientAvailabilityManager,
        NetworkMacrosResolver,
        ClientProcessor,
        ResourcesStatistics,
        StatisticsProcessor,
        ClientSlotsMonitor,
        TaskStatusNotifier,
        TaskQueueValidator,
        GroupSynchronizer,
        TaskStateSwitcher,
        TaskStatusChecker,
        HostsCacheUpdater,
        UpdateRobotOwners,
        AutoRestartTasks,
        CheckSemaphores,
        MetricsReporter,
        TasksStatistics,
        CleanResources,
        MessengerQBot,
        MongoMonitor,
        MongoChecker,
        TasksEnqueuer,
        CpuBalancer,
        TelegramBot,
        Scheduler,
        Cleaner,
        Mailman,
        Juggler,
        MDSCleaner,
        MdsLruCleaner,
        BackupResources,
        ReplicateResources,
        BackupResourcesToMds,
        CopyResourcesToWarehouse,
        TaskTagsChecker,
        LogbrokerPublisher,
    )
}
