import logging

from sandbox import common
import sandbox.common.types.misc as ctm

from sandbox.services.base import service
from sandbox.services.modules.juggler import components


class Juggler(service.ThreadedService):
    notification_timeout = 5
    tick_interval = 30

    OAUTH_TOKEN_TTL = 60

    def __init__(self, *args, **kwargs):
        super(Juggler, self).__init__(*args, **kwargs)
        self.make_checkers()

    @staticmethod
    def __make_checker(checker_class, *args, **kwargs):
        kwargs.update(
            logger=logging.getLogger(checker_class.__name__),
        )
        return checker_class(*args, **kwargs)

    # noinspection PyAttributeOutsideInit
    def make_checkers(self):
        self.tasks_autodeploy = self.__make_checker(
            components.TasksAutodeploy,
            self.oauth_token,
            self.sandbox_config.server.api.port,
            self.service_config["tasks_code_autodeploy"]["breakage_timeout"],
            dummy=self.sandbox_config.common.installation != ctm.Installation.PRODUCTION,
        )

    @property
    def targets(self):
        return [
            self.Target(self.tasks_autodeploy.check),
        ]

    @property
    @common.patterns.ttl_cache(OAUTH_TOKEN_TTL)
    def oauth_token(self):
        return common.utils.read_settings_value_from_file(self.sandbox_config.server.auth.oauth.token)
