import abc


class BaseCheck(object):
    __metaclass__ = abc.ABCMeta

    @abc.abstractproperty
    def juggler_check(self):
        pass

    def __init__(self, *args, **kwargs):
        self.status = None
        self.message = None
        self.dummy = kwargs.pop("dummy", True)
        self.logger = kwargs.pop("logger", None)

    @abc.abstractmethod
    def check(self):
        pass

    def send_to_juggler(self):
        if self.logger:
            self.logger.debug("[%s] %s", self.status, self.message)

        if self.dummy:
            return

        send_status = getattr(self.juggler_check, self.status.lower())
        send_status(self.message)
