import logging

from sandbox import common
from sandbox.services import base

logger = logging.getLogger(__file__)


class NetworkMacrosResolver(base.SingletonService):
    BANNED_NETWORK_MACROSES = ["_UNIFIEDUSERNETS_", "_SELENIUMGRIDNETS_", "_KOLHOZ_AGENT_NETS_"]
    HBF_URL = "https://hbf.yandex.net"  # url for resolving network macroses
    CONTEXT_BANNED_KEY = "banned_networks"  # key in context for banned networks

    tick_interval = 60

    @common.patterns.singleton_property
    def hbf_client(self):
        return common.rest.Client(self.HBF_URL)

    def tick(self):
        banned_nets = self.context.setdefault(self.CONTEXT_BANNED_KEY, {})
        for macros in self.BANNED_NETWORK_MACROSES:
            try:
                banned_nets[macros] = self.hbf_client.macros[macros].read()
            except self.hbf_client.HTTPError as ex:
                logger.error("Can't update networks for banned macros %s. Exception: %s", macros, str(ex))
