import abc

from sandbox import common


DATETIME_CONVERTER = common.api.DateTime()


class Processor(object):
    """ Base signal processor class """

    DATE_FIELD = "date"
    TIMESTAMP_FIELD = "timestamp"

    @classmethod
    @abc.abstractmethod
    def initialize(cls, ctx):
        """ Perform some initialization before the processing. Put database creation, etc. here """

    @abc.abstractmethod
    def process(self, signals, signal_type, logger_, timer):
        """ Process a batch of signals before sending them into the outer space. """
