import logging

from sandbox.services import base
from sandbox.yasandbox import controller


logger = logging.getLogger(__name__)


class TaskQueueValidator(base.SingletonService):
    """ Validator of the task queue for Service Q """
    tick_interval = 15
    NOTIFICATION_TIMEOUT = 5
    ENQUEUED_TASKS_DELAY = 60  # don't touch tasks in ENQUEUED but not in queue newer than the time, in seconds

    def tick(self):
        controller.TaskQueue.validate(
            logger, lambda: self._stop_requested.is_set(),
            enqueued_tasks_delay=self.ENQUEUED_TASKS_DELAY
        )
