PY2_LIBRARY()

OWNER(g:sandbox-dev)

PY_SRCS(
    __init__.py
    auto_restart_tasks.py
    backup_resources.py
    check_semaphores.py
    clean_resources.py
    cleaner.py
    client_availability_checker.py
    client_availability_manager.py
    client_processor.py
    client_slots_monitor.py
    cpu_balancer.py
    group_synchronizer.py
    logbroker_publisher.py
    messengerq_bot.py
    mongodb_reporter.py
    network_macros_resolver.py
    resources_statistics.py
    scheduler.py
    tasks_enqueuer.py
    task_queue_validator.py
    task_state_switcher.py
    task_status_checker.py
    task_status_notifier.py
    tasks_statistics.py
    telegram_bot.py
    hosts_cache_updater.py
    mailman.py
    mds_cleaner.py
    mds_lru_cleaner.py
    task_tags_checker.py
)

PEERDIR(
    contrib/python/bleach
    contrib/python/futures
    contrib/python/pymongo
    contrib/python/botocore
    contrib/python/requests
    contrib/python/six

    kikimr/public/sdk/python/persqueue

    logbroker/unified_agent/client/python

    sandbox/common
    sandbox/deploy
    sandbox/serviceq

    sandbox/services/base
    sandbox/services/modules/juggler
    sandbox/services/modules/metrics_reporter
    sandbox/services/modules/statistics_processor
    sandbox/services/modules/update_robot_owners

    sandbox/web/api
    sandbox/web/templates/notifications

    sandbox/yasandbox/controller
    sandbox/yasandbox/database
)

END()

RECURSE(
    juggler
    statistics_processor
    update_robot_owners
)

RECURSE_FOR_TESTS(
    tests
)
