# coding: utf-8
from __future__ import unicode_literals, absolute_import


class BadRequest(RuntimeError):
    """Это исключение нужно выкидывать в случае, если были переданы неверные данные."""


class AccessDenied(RuntimeError):
    """Это исключение кидаем, когда по тем или иным причинам доступ к странице запрещён."""


class UserNotFound(BadRequest):
    """Пользователь не найден в базе данных"""


class GroupNotFound(BadRequest):
    """Пользователь не найден в базе данных"""


class RoleNotFound(BadRequest):
    """Система не знает о таком узле дерева ролей"""


class UnsupportedApi(BadRequest):
    """Система не реализовала данный метод API"""
