# coding: utf8
"""
statinfra_api shared things (django-dependent, i.e. not importable
without configured settings).
"""
from __future__ import absolute_import

from rest_framework.views import APIView
from rest_framework.authentication import BasicAuthentication

from sandbox.step.statbox_django_utils.restframework.views import ParametrizedViewMixin
from sandbox.step.statbox_django_utils.restframework.no_csrf_auth import CsrfExemptSessionAuthentication


class CommonViewMixin(ParametrizedViewMixin, APIView):
    """
    Common mixin for most Statinfra API views.
    """
    authentication_classes = (CsrfExemptSessionAuthentication, BasicAuthentication)
