from __future__ import absolute_import

import logging

from sandbox import common

_log = logging.getLogger("celery.tasks")


class Sandbox(common.rest.Client):
    def __init__(self, **kws):
        from .. import settings as conf
        kws.update(
            base_url=conf.SANDBOX_API_URL,
            auth=conf.SANDBOX_TOKEN,
            component="step",
            logger=_log
        )
        kws.setdefault("total_wait", conf.TASK_TIMEOUT_TO_RECOVER)
        super(Sandbox, self).__init__(**kws)
