from __future__ import absolute_import

import mongoengine as me


class EventDesc(me.Document):
    name = me.StringField(required=True, unique=True)
    required_fields = me.ListField(me.StringField())
    optional_fields = me.ListField(me.StringField())
    author = me.StringField()
    description = me.StringField()

    list_in_idm = me.BooleanField(default=False)
    public = me.BooleanField(default=True)

    meta = {
        'indexes': [
            ('name',),
        ]
    }

    @property
    def fields(self):
        return self.required_fields + self.optional_fields
