from __future__ import absolute_import

import mongoengine as me

from .event import Event
from .task import Task
from ..enums import EventStoryState


class EventStory(me.Document):
    initial_event = me.ReferenceField(Event)

    produced_events = me.ListField(me.ReferenceField(Event))
    produced_tasks = me.ListField(me.ReferenceField(Task))

    task_stopping_info = me.DictField()

    state = me.StringField(default=EventStoryState.NEW)

    def to_dict(self):
        return {
            'initial_event': self.initial_event.to_dict(),
            'produced_events': [x.to_dict() for x in self.produced_events],
            'produced_tasks': [
                dict(
                    stopping_info=self.task_stopping_info.get(str(task.id)),
                    **task.to_dict()
                ) for task in self.produced_tasks
            ],
            'state': self.state
        }
