from __future__ import absolute_import

from django.conf.urls import url

from .views import (
    EventsCollection,
    EventsItem,
    ActionConfigCollection,
    ActionConfigTryWebhook,
    ActionConfigItem,
    last_tasks_info,
    slow_tasks_top,
    protected_view,
    EventDescriptionCollection,
    EventDescriptionItem,
    RejectEvent,
    EventStoryItem,
    EventStoryCollection
)


urlpatterns = [
    url(r'^events/(?P<event_id>.+)$', EventsItem.as_view(), name='events-item'),
    url(r'^events$', EventsCollection.as_view(), name='events-collection'),
    url(r'^configs$', ActionConfigCollection.as_view(), name='configs-collection'),
    url(r'^configs/try/webhook$', ActionConfigTryWebhook.as_view(), name='configs-try-webhook'),
    url(r'^configs/(?P<ac_id>\d+)$', ActionConfigItem.as_view(), name='configs-item'),
    url(r'^last_tasks_info$', last_tasks_info, name='last-tasks-info'),
    url(r'^slow_tasks_top$', slow_tasks_top, name='slow-tasks-top'),
    url(r'^slow_tasks_top$', slow_tasks_top, name='slow-tasks-top'),
    url(r'^protected', protected_view, name='protected-view'),
    url(r'^event_desc$', EventDescriptionCollection.as_view(), name='event-desc-collection'),
    url(r'^event_desc/(?P<name>.+)', EventDescriptionItem.as_view(), name='event-desc-item'),
    url(r'^reject_event', RejectEvent.as_view(), name='reject-event'),
    url(r'^event_story$', EventStoryCollection.as_view(), name='event-story-collection'),
    url(r'^event_story/(?P<story_id>.+)$', EventStoryItem.as_view(), name='event-story-item'),
]
