# coding: utf-8
from __future__ import absolute_import


from django.conf.urls import include, url
from django.conf.urls.static import static
from django.contrib import admin
from . import views

from django.conf import settings


admin.autodiscover()


urlpatterns = [
    url(r'^whoami/', views.whoami, name='whoami'),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^step/', include('sandbox.step.statinfra_api.events.urls')),
    url(r'^', include('sandbox.step.statinfra_api.events.urls')),
]

urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)

urlpatterns_base = urlpatterns
urlpatterns = [
    url(r'^favicon\.ico$', views.fake_favicon, name='favicon'),
    url(r'^api/', include(urlpatterns_base)),
    url(r'^api/v1/', include(urlpatterns_base, namespace='v1')),
    url(r'^dostup/', include('sandbox.step.django_idm_api.urls')),
    url(r'^ping/?$', views.ping, name='ping'),
]
