# coding: utf8

from __future__ import division, absolute_import, print_function, unicode_literals
import logging
from django.conf import settings
from rest_framework.decorators import api_view, permission_classes
from rest_framework.response import Response

_log = logging.getLogger(__name__)


@api_view(['GET', 'POST', 'PUT', 'DELETE'])
@permission_classes([])
def whoami(request, **kwargs):
    data = dict(
        method=request.method,
        yauser=repr(getattr(request, 'yauser', None)),
        user=repr(getattr(request, 'user', None)),
        debug=settings.DEBUG,
    )
    user = getattr(request, 'user')
    if user:
        data['groups'] = [(g.type, g.name) for g in user.user_groups]
    _log.debug("whoami: %r", data)
    return Response(data)


@api_view(['GET'])
def ping(request):
    return Response()


@api_view(['GET'])
def fake_favicon(request):
    return Response()
