from __future__ import print_function

import sys
import logging
import argparse

from sandbox import common

import sandbox.taskbox.utils as tb_utils
import sandbox.taskbox.config as tb_config
import sandbox.taskbox.dispatcher.server as dispatcher


logger = logging.getLogger(__name__)


SERVICE_NAME = "Dispatcher"


def parse_args():
    parser = argparse.ArgumentParser(description="Taskbox " + SERVICE_NAME)
    parser.add_argument("--stderr-log", help="write logs to stderr", action="store_true")
    parser.add_argument("--clean-run", action="store_true", help="kill all previous workers")
    parser.add_argument("-v", "--version", action="store_true", help="print version")

    args = parser.parse_args()
    if args.version:
        print(tb_utils.svn_version())
        sys.exit(0)
    return args


def main():
    args = parse_args()
    common.config.ensure_local_settings_defined()
    config = tb_config.Registry()

    tb_utils.setup_logger(config.taskbox.log, SERVICE_NAME.lower(), args.stderr_log)

    logger.info("Initializing taskbox %s", SERVICE_NAME)

    server = dispatcher.Server(config, args.clean_run)
    tb_utils.run_joint_service(server, SERVICE_NAME)

    if config.taskbox.dispatcher.kill_workers_on_stop:
        server.worker_registry.kill_workers()


if __name__ == "__main__":
    main()
