import time

import gevent

from sandbox.common import enum
from sandbox.common import statistics as common_statistics
import sandbox.common.types.statistics as ctss


class TaskboxComponent(enum.Enum):
    enum.Enum.lower_case()

    DISPATCHER = None
    WORKER = None


class TaskboxRequestResult(enum.Enum):
    enum.Enum.lower_case()

    SUCCESS = None
    ERROR = None
    INTERNAL_ERROR = None  # internal errors (to be distinguished from user-induced ones)


def system_statistics_collector(statistics, interval, logger, stop_checker):
    logger.info("System statistics collector started")
    try:
        last_running = time.time()
        while not stop_checker():
            gevent.sleep(max(0, last_running + interval - time.time()))
            last_running = int(time.time())
            statistics.checkpoint()

    finally:
        logger.info("System statistics collector stopped")


class TaskboxStatsSignalHandler(common_statistics.ClientSignalHandler):
    types = (
        ctss.SignalType.TASKBOX_STATISTICS,
    )
