from __future__ import print_function

SERVICE_NAME = "Worker"


def main():
    """
    gevent.monkey.patch_all() must be behind all imports but we don't need to call it outside of taskbox worker.
    So we put all import to main() function.
    """
    import gevent.monkey
    gevent.monkey.patch_all()  # noqa

    import sys
    import logging
    import argparse

    from sandbox.common import config as common_config
    from sandbox.common import encoding as common_encoding

    import sandbox.taskbox.utils as tb_utils
    import sandbox.taskbox.config as tb_config
    import sandbox.taskbox.worker.server as worker

    logger = logging.getLogger(__name__)

    def parse_args():
        parser = argparse.ArgumentParser(description="Taskbox " + SERVICE_NAME)
        parser.add_argument("--id", help="id of worker instance", required=True)
        parser.add_argument("--tasks-binary-id", help="tasks binary resource id", required=True)
        parser.add_argument("--socket", help="path to socket for communication", required=True)
        parser.add_argument("-v", "--version", action="store_true", help="print version")

        args = parser.parse_args()
        if args.version:
            print(tb_utils.svn_version())
            sys.exit(0)
        return args

    args = parse_args()

    # This entry point is exclusive for use from Dispatcher,
    # and it must always provide the config.
    common_config.ensure_local_settings_defined()

    common_encoding.setup_default_encoding()

    config = tb_config.Registry()
    config.taskbox.worker.server.host = None
    config.taskbox.worker.server.port = None
    config.taskbox.worker.server.unix = args.socket

    tb_utils.setup_worker_logger(
        config.taskbox.worker.log, SERVICE_NAME.lower(), "{}.{}".format(args.tasks_binary_id, args.id)
    )
    instance_name = "{} {} for sbr:{}".format(SERVICE_NAME, args.id, args.tasks_binary_id)
    logger.info("Initializing taskbox %s", SERVICE_NAME)

    try:
        server = worker.Server(config)
        tb_utils.run_joint_service(server, instance_name)
    except:
        logger.exception("Fatal error")
        raise


if __name__ == "__main__":
    main()
