import argparse

from sandbox.tasklet.sidecars.resource_manager.lib import types
from sandbox.tasklet.sidecars.resource_manager.run import server as rm_server


def main():
    parser = argparse.ArgumentParser(
        formatter_class=argparse.RawTextHelpFormatter,
        description="Service for managing Sandbox resources"
    )
    parser.add_argument(
        "--runtime", type=str, choices=list(runtime.value for runtime in types.Runtime),
        default=types.Runtime.SANDBOX.value, help="Current runtime"
    )
    parser.add_argument(
        "--iteration", type=int, default=0, help="Number of task restarts. Specific for Sandbox runtime."
    )
    parser.add_argument(
        "--address", type=str, default="[::1]:{}".format(rm_server.ResourceManagerServer.DEFAULT_PORT),
        help="Address for service"
    )
    parser.add_argument(
        "--workers", type=int, default=rm_server.ResourceManagerServer.DEFAULT_MAX_WORKERS,
        help="Number of maximum workers"
    )
    args = parser.parse_args()
    server = rm_server.ResourceManagerServer(
        runtime=args.runtime,
        iteration=args.iteration,
        address=args.address,
        max_workers=args.workers
    )
    try:
        server.start()
        server.server.wait_for_termination()
    except Exception as ex:
        print(ex)
        server.stop()
