import logging

from sandbox.agentr import client as aclient
from sandbox.common import config as common_config

from sandbox.tasklet.sidecars.resource_manager.handlers import base


class SandboxHandler(base.BaseHandler):
    """ Class for managing resources in Sandbox """
    def __init__(self, token: str, iteration: int, config: common_config.Registry) -> None:
        """
        :param token: token for Sandbox session
        :param iteration: number of task restart
        :param config: Sandbox config
        """
        super(SandboxHandler, self).__init__(token, config)
        self.iteration = iteration
        self.aclient = aclient.Session(self.token, self.iteration, 0, logging.getLogger())

    def download_resource(self, resource_id: int) -> str:
        """ Download resource via AgentR to some directory and return path to downloaded resource """
        return self.aclient.resource_sync(resource_id)

    def create_resource(
        self, resource_type: str, arch: str, owner: str, attributes: dict[str, str], path: str, description: str
    ) -> dict:
        """ Create resource in Sandbox via AgentR, complete it (mark as READY) and return it meta data """
        resource = self.aclient.resource_register(path, resource_type, description, arch, attributes)
        return self.aclient.resource_complete(resource["id"])
