from concurrent import futures

import grpc

from sandbox.tasklet.sidecars.resource_manager.lib import types
from sandbox.tasklet.sidecars.resource_manager.proto import resource_manager_api_pb2_grpc
from sandbox.tasklet.sidecars.resource_manager.run import service


class ResourceManagerServer:
    """ Server class for Resource manager """
    DEFAULT_PORT = 50000  # Default port for Resource manager server
    DEFAULT_MAX_WORKERS = 32  # Default number of maximum workers for Resource manager server

    def __init__(
        self, runtime: types.Runtime, iteration: int = None, address: str = "[::]:{}".format(DEFAULT_PORT),
        max_workers: int = DEFAULT_MAX_WORKERS
    ) -> None:
        """
        :param runtime: current runtime
        :param iteration: number of task restarts which specific for Sandbox runtime
        :param address: address for server
        :param max_workers: maximum number of workers
        """
        self.service = service.ResourceManagerAPI(
            runtime=runtime,
            iteration=iteration
        )
        self.address = address
        self.max_workers = max_workers
        self.server = None

    def start(self) -> None:
        """ Start Sandbox manager server """
        address = self.address
        self.server = grpc.server(futures.ThreadPoolExecutor(max_workers=self.max_workers))
        resource_manager_api_pb2_grpc.add_ResourceManagerAPIServicer_to_server(self.service, self.server)
        self.server.add_insecure_port(address)
        self.server.start()

    def stop(self) -> None:
        """ Stop Sandbox manager server """
        if self.server is not None:
            self.server.stop(None).wait()
