import os
import re
import json

import pytest

from yatest import common as yatest_common
from yalibrary import makelists
from library.python import resource

PREFIX = "sandbox/projects/"
QUOTES_RE = re.compile(r"[\"']")


def test_projects_ya_make():

    path = yatest_common.source_path()
    ya_make_path = os.path.join(path, "sandbox/projects/ya.make")

    ml = makelists.from_file(ya_make_path)

    variables = makelists.sets_values(ml, "")
    variables = {key: [QUOTES_RE.sub("", x) for x in values] for key, values in variables.items()}

    peerdirs = makelists.get_paths(ml, "PEERDIR", variables)
    potential_offenders = {p[len(PREFIX):] for p in peerdirs if p.startswith(PREFIX) and p.count("/") > 2}

    whitelist_raw = resource.find("sandbox/tasks/tests/ya_make/whitelist.json").decode()
    whitelist = set(json.loads(whitelist_raw))

    offenders = sorted(potential_offenders - whitelist)

    if not offenders:
        return

    offenders = [PREFIX + x for x in offenders]
    example = "/".join(offenders[0].split("/")[:3])

    offenders_text = "\n".join("* {}".format(x) for x in offenders)

    message = (
        "The following paths cannot be PEERDIR'd in sandbox/projects/ya.make:\n{}\n"
        "Only first-level paths (e.g. {}) are allowed for new PEERDIR's."
        .format(offenders_text, example)
    )

    pytest.fail(message)
