import json
import re
import argparse

from yalibrary import makelists

PREFIX = "sandbox/projects/"
QUOTES_RE = re.compile(r"[\"']")


def main():
    arg_parser = argparse.ArgumentParser()
    arg_parser.add_argument("-i", dest="ya_make", required=True, type=argparse.FileType("r"))
    arg_parser.add_argument("-o", dest="whitelist", required=True, type=argparse.FileType("w"))
    args = arg_parser.parse_args()

    builder = makelists.mk_builder.Builder()
    parser = makelists.mk_parser.Parser(builder)
    parser.parse(args.ya_make.read())

    ml = builder.root

    variables = makelists.sets_values(ml, "")
    variables = {key: [QUOTES_RE.sub("", x) for x in values] for key, values in variables.items()}

    peerdirs = makelists.get_paths(ml, "PEERDIR", variables)

    offenders = sorted(p[len(PREFIX):] for p in peerdirs if p.startswith(PREFIX) and p.count("/") > 2)
    print("Found {} offenders for the whitelist...".format(len(offenders)))

    json.dump(offenders, args.whitelist, indent=2)
    print("", file=args.whitelist)  # empty line
    print("Updated!")
