var GRID = 'http://127.0.0.1:4444/wd/hub'; // 'http://selenium:selenium@sg.yandex-team.ru:4444/wd/hub';
var BASE_URL = 'https://localhost.yandex-team.ru:9000'; // 'https://evilj0e-local.qloud.yandex-team.ru';
var SPECS = [
    'spec/tests/*.smoke.spec.js',
    'spec/tests/*.regression.spec.js'
];
var HELPERS_DIR = './spec/helpers/browser';

var requireDir = require('require-dir');

module.exports = {
    specs: SPECS,
    grid: GRID,
    baseUrl: BASE_URL,
    sessionsPerBrowser: 1,
    retry: 5,
    browsers: {
        chrome: {
            desiredCapabilities: {
                browserName: 'chrome'
            }
        },
    },
    prepareBrowser: function (browser) {

        var helpers = requireDir(HELPERS_DIR);

        Object.keys(helpers).forEach(function (name) {
            return helpers[name](browser);
        });
    }
};
