# Разработка

## Подготовка окружения для разработки

### Пакеты
Код проекта лежит в `svn`, для того, чтобы нам его получить нужно [поставить себе](https://subversion.apache.org/download.cgi#recommended-release) `svn`

Для разработки и сборки проекта нам нужен `nodejs`. Ставим его:

```bash
sudo apt-get install nodejs
npm config set registry http://npm.yandex-team.ru/
```

### Авторизация

Если вы **планируете разрабатываться на локальной машине**, то нужно у себя в хостах (`/etc/hosts`) прописать:
```bash
127.0.0.1 localhost.yandex-team.ru 
```
Это нужно для того, чтобы локальный сервер смог получать корректные куки и вы были авторизованы на разработческом сервере.

## Разворачивание проекта

1) Клонируем проект Sandbox ([все ссылки проекта](LINKS.md)) из [Аркадии](https://a.yandex-team.ru/) на локальную машину
```bash
svn checkout svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/sandbox/ui
```

2) Переходим в директорию склонированного проекта
```bash
cd sandbox-ui
```

3) Устанавливаем зависимости
```bash
npm install
```

## Сборка и запуск сервера для разработки

Для корректной работы в проекте нужна авторизация в паспорте, для правильного проброса кук нужно сделать [вот это](#Авторизация).

Сборка осуществляется с помощью gulp ([весь стек проекта](TECHNOLOGIES.md)).
В `default` задаче производится сборка проекта и запуск разработческого сервера [по адресу на 9000 порту](https://localhos.yandex-team.ru:9000).

```bash
./node_modules/.bin/gulp
```

## Разработка фичи
Так как у нас пока `svn`, разработку ведём без веток, коммитим в репозиторий после того, как задача полностью выполнена, написаны и пройдены тесты, отревьюена и зарелизена на тестинг.
Если нужно срочно сделать хотфикс, то делаем `shelve` текущего не закомиченного кода, решаем задачу, проходим все этапы, описанные ниже, катим в продакшен, делаем `unshelve` и возвращаемся к задаче, которую решали до этого.

1) Ставим задаче статус `В работе`;

2) Пишем решение поставленной задачи;

3) Обновляем версию проекта. Версионирование по semver.
```bash
npm version TYPE
```
где **TYPE** – patch, minor, major

Версию обновляем именно так, потому что таким способом кроме package.json версия обновялется ещё и в npm-shrinkwrap.json.

4) Перед каждым коммитом запускаем линтер:
```bash
./node_modules/.bin/gulp eslint
```
5) После того, как мы исправили все ошибки и линт выполнился без ошибок пишем тесты на новую / исправленную функциональность. 

На данный момент в проекте подняты и сконфигурированы 2 системы тестирования:

* [Интеграционные тесты](CREATING_TESTS.md#Интеграционные-тесты).

Сконфигурирована связка `hermione` + `selenium (standalone / sg.yandex-team.ru)` + `chai`. 

* [Юнит тесты](CREATING_TESTS.md#Юнит-тесты).

Сконфигурирована связка `karma` + `phanthom` + `jasmine`. 

6) После того, как тесты написаны и все зелёные, добавляем все новые файлы в систему контроля версий и отправляем задачу на ревью через [ReviewBoard](https://rb.yandex-team.ru). Для того необходимо выполнить следующие команды в консоли:
```bash
svn add ./path/to/new/file.js
svn ci -m "REVIEW:NEW ОЧЕРЕДЬ-НННН: Название-задачи"
```
Коммит сообщение имеет следующий формат:

**REVIEW:NEW** – обязательные ключевые слова для того, чтобы наш новый код не улетел в Аркадию, а был перехвачен ReviewBoard и отправлен на ревью;
**ОЧЕРЕДЬ-НННН: Название-задачи** – ваше коммит-сообщение, например, SANDBOX-3396: Тормозит отрисовка страниц в веб-интерфейсе.

7) После успешного выполнения предыдущего шага переходим по ссылке на ревью в ReviewBoard вида: https://rb.yandex-team.ru/arc/r/XXXXXX/, где XXXXXX – уникальный номер ревью, которую получаем в консоли;

8) Отмечаем в качестве `people` в `Reviewers` evilj0e@, blackheart@, blinovskov@, пишем `description` и нажимаем кнопку `Publish`;

9) После того, как ревьюеры отсмотрят код и никаких доработок не останется, ревьюеры нажмут кнопку `Ship it`, мы можем закоммитить код в Аркадию так:
```bash
svn ci -m "REVIEW:XXXXXX ОЧЕРЕДЬ-НННН: Название-задачи"
```
где **XXXXXX** – номер, выданный ранее ReviewBoard для нашего ревью.

С помощью этой команды наш код пойдёт через ревьюборд, ревьюборд его пропустит и код закоммитится в Аркадию

10) Идём на [тестинг](https://www-sandbox1.n.yandex-team.ru), жмём кнопку `Create task`, выбираем тип задачи `BUILD_SANDBOX` и жмём `Create`

11) Заполняем:
* `description` сообщением в формате **ОЧЕРЕДЬ-НННН: Название-задачи**, как было описано в пункте 4;
* из блока `Packages` выбираем только `UI`;
* в `Changelog` выбираем `testing`

После этих действий кликаем кнопку `Run`

12) После того, как задача перейдёт в статус `Success`, жмём на кнопку `Release`. 

В появившемся окне выбираем в `Subject` `testing`, заполняем поле `Changelog and comments` в виде

```
Changelog from previous "testing" release tag:

* ОЧЕРЕДЬ-НННН: Название-задачи
```

13) Жмём `Release`.

14) После того, как в UI в тестинге версия обновится до новой, проверяем новую функциональность в тестинге и, если всё хорошо, выполняем пункты 8 - 11 в [продакшене](https://sandbox.yandex-team.ru), вместо `testing` выбираем `stable`.

15) После того, как в UI в продакшене версия обновится до новой, проверяем новую функциональность в продакшене и, если всё хорошо, то ставим задаче статус `Ready for RC`

## Проверка качества кода
```bash
./node_modules/.bin/gulp eslint
```

## Продакшен сборка

* [Разворачиваем проект](#Разворачивание-проекта)
* Выполняем make и получаем продакшн сборку в `./path/to/root/dist`
```bash
make clean
make
```
