var args = require('minimist')(process.argv);
var isProduction = args.environment === 'production';

var packageConfig = require('../package.json');
var version = packageConfig.version;
var assets = 'dist/assets/' + version;
var baseHost = isProduction ? '//sandbox-ui.s3.mds.yandex.net' : '';
var baseUrl = baseHost + '/assets/' + version;
var fontPath = assets + '/fonts';
var imagesPath = assets + '/images';

module.exports = {
    baseUrl: baseUrl,
    fontPath: fontPath,
    imagesPath: imagesPath,

    less: {
        srcFile: './src/less/bootstrap.less',
        srcDir: './src/less',
        dest: assets + '/css',

        paths: [
            __dirname + '/../node_modules/y-components/dist',
            __dirname + '/../src/less',
            __dirname + '/../node_modules/bemmy/src'
        ]
    },

    html: {
        src: './src/index.html',
        dest: 'dist',
        version: version,
        baseUrl: baseUrl,
        date: Date.now()
    },

    js: {
        src: __dirname + '/../src/js/bootstrap.js',
        dest: assets + '/js',
        target: 'scripts.js'
    },

    vendor: {
        dest: assets + '/js',
        target: 'vendor.js',
        libs: [
            'node_modules/jquery/dist/jquery.js',
            'node_modules/jquery-ui-dist/jquery-ui.js',
            'node_modules/jquery.browser/dist/jquery.browser.js',
            'node_modules/jquery-validate/jquery-validate.js',
            'node_modules/underscore/underscore.js',
            'node_modules/highcharts-release/highcharts.js',
            'node_modules/highcharts-release/highcharts-more.js',
            'node_modules/highcharts-release/modules/exporting.js',
            'node_modules/moment/moment.js',
            'node_modules/clipboard/dist/clipboard.min.js',
            'node_modules/backbone/backbone.js',
            'node_modules/backbone.babysitter/lib/backbone.babysitter.js',
            'node_modules/backbone.wreqr/lib/backbone.wreqr.js',
            'node_modules/backbone-virtual-collection/backbone.virtual-collection.js',
            'node_modules/backbone.marionette/lib/backbone.marionette.js',
            'node_modules/backbone.marionette/lib/core/amd/backbone.marionette.js',
            // RUM counter
            'node_modules/rum-counter/dist/bundle/send.min.js',
            'node_modules/rum-counter/dist/bundle/ajax.min.js',
            'node_modules/rum-counter/dist/bundle/implementation.min.js',
            'node_modules/rum-counter/dist/bundle/onload.min.js',
            'node_modules/rum-counter/dist/bundle/retries.min.js'
        ]
    },

    images: {
        src: ['./src/images/**/*', './src/images/*'],
        dest: assets + '/images'
    },

    favicon: {
        src: 'src/favicon[.|-]*',
        dest: 'dist'
    },

    bemmy: {
        svg: assets,
        font: assets + '/fonts',
        images: assets + '/images',
        iconsPath: assets + '/images/icons' // workaround
    },
    /*
        tanker: {
            src: __dirname + '/../src/i18n/default.json',
            token: '<PROJECT_TOKEN_PLACE_HERE>',
            project: '<PROJECT_NAME>',
            keyset: '<KEYSET_NAME>',
            dist: assets + '/i18n',
            outputFormat: 'i18next',
            method: 'onlyadd'
        },*/

    karma: {
        configFile: __dirname + '/../karma.conf.js'
    },

    bump: {
        name: 'sandbox-frontend'
    }
};
