const config = require('../config').html;
const gulp = require('gulp');
const tools = require('yasap-gulp-tools');
const args = require('minimist')(process.argv);

const fs = require('fs');
const interfaceCode = fs.readFileSync(`${__dirname}/../../node_modules/rum-counter/dist/inline/interface.min.js`, 'utf8');
const longtaskCode = fs.readFileSync(`${__dirname}/../../node_modules/rum-counter/dist/inline/longtask.min.js`, 'utf8');
const initCode = getRUMInitCode();

function getRUMInitCode() {
    const region = '213';

    return args.environment === 'production' ? `
        var isProduction = window.location.host === 'sandbox.yandex-team.ru';

        if (isProduction) {
            var pages = {
                '/': '.3039',
                'tasks': '.3039',
                'task': '.3040',
                'resources': '.3041',
                'resource': '.3042',
                'schedulers': '.3043',
                'scheduler': '.3045',
                'clients': '.3046',
                'releases': '.3047',
                'admin': '.3048',
                'statistics': '.3049',
                'oauth': '.3050',
                'error': '.1030',
                'notifications': '.3051',
                'service-notifications': '.188.3051',
                'host': '.3052',
                'preferences': '.3054',
                'unknown': '.836'
            };
            var result = {};

            document.cookie.split(';').forEach(function (value) {
                value = value.trim().split('=');
                result[value[0]] = value.join('=');
            });

            var loggedState = result['yandex_login'] ?
                '.3055' : // logged
                '.3056';  // guest
            
            var page;

            if (window.location.pathname === '/') {
                page = pages['/'];
            } else {
                var hash = window.location.pathname.split('/')[1];
                page = pages[hash] || pages.unknown;
            }

            Ya.Rum.init({
                beacon: !!navigator.sendBeacon,
                clck: 'https://yandex.ru/clck/click',
                slots: [],
                reqid: Date.now() + '.' + Math.random()
            }, {
                '287': '${region}',
                '143': '28.3030' + loggedState + page,
                '2923': 1
            });
        }
    ` : '';
}

gulp.task('html', function () {
    return tools
        .html(config.src, {
            baseUrl: config.baseUrl,
            version: config.version.replace('/', ''),
            date: config.date,
            rum: {
                interface: interfaceCode,
                longtask: longtaskCode,
                init: initCode
            }
        })
        .pipe(gulp.dest(config.dest));
});
