var config = require('../config').js;

require('injectify-view/inject');
require('injectify-include/inject');

var source = require('vinyl-source-stream');
var streamify = require('gulp-streamify');
var gulp = require('gulp');
var browserify = require('browserify');
var reactify = require('reactify');
var watchify = require('watchify');
var minifier = require('gulp-uglify/minifier');
var uglifyjs = require('uglify-js-harmony');
var args = require('minimist')(process.argv);
var through = require('through');

process.env.NODE_ENV = (args.environment === 'production') ?
    'production' :
    'development';

function buildScript () {
    var props = {
        entries: [config.src],
        cache: {},
        packageCache: {},
        fullPaths: false,
        delay: 100,
        ignoreWatch: true,
        transform: [
            [ 'babelify', {presets: [ 'es2015', 'react' ], babelrc: false} ],
            [ 'injectify', {global: true} ]
        ],
        plugins: [],
        extensions: ['.hbs'],
        debug: true,
        name: 'scripts.js'
    };

    var bundler = args.environment !== 'production' ?
        watchify(browserify(props)) :
        browserify(props);

    function rebundle () {
        return bundler.bundle()
            .pipe(source(config.target))
            .pipe(args.environment === 'production' ?
                streamify(minifier({preserveComments: false}, uglifyjs)) :
                through()
            )
            .pipe(gulp.dest(config.dest));
    }

    bundler.on('update', function () {
        rebundle();
    });

    return rebundle();
}

gulp.task('js', function () {
    gulp
        .src('src/externalHelpers.js')
        .pipe(gulp.dest('dist'));

    return buildScript();
});
