'use strict';

var gulp = require('gulp');

var bs = gulp.task('server', function () {

    var tools = require('yasap-gulp-tools');

    var pem = require('path').join(__dirname, '..', '..', 'localhost.yandex-team.ru.pem');
    var options = {
        https: {
            key: pem,
            cert: pem
        },
        port: 9000
    };

    // var index = 0;

    return tools.server(options)
        // .use(function (req, res, next) {
        //     if (req.url.indexOf('/release/') !== -1) {
        //         index++;

        //         if (index % 3 === 1) {
        //             index = 2;

        //             res.writeHead(503,
        //                 req.url && {'Location': req.url},
        //                 {'Content-Type': 'application/json'}
        //             );

        //             res.end(JSON.stringify({}));
        //         } else {
        //             next();
        //         }
        //     } else {
        //         next();
        //     }
        // })
        .forward(/\/api\/v1\.0\/task\/(\d+)\/children/, function (matched) {

            return 'https://sandbox.yandex-team.ru:443/api/v1.0/task/' + matched[1] + '/children';
        })
        .forward(/\/api\/staff(.*)/, function (matched) {

            return 'https://staff-api.yandex-team.ru:443/' + matched[1];
        })
        .forward(/\/api\/(.*)/, 'https://sandbox.yandex-team.ru:443')
        .rewriteToIndex()
        .listen();
});

gulp.task('mock-server', function () {

    var tools = require('yasap-gulp-tools');
    var mockMapper = require('./../../spec/mocks/mockMapper');

    var pem = require('path').join(__dirname, '..', '..', 'localhost.yandex-team.ru.pem');
    var options = {
        https: {
            key: pem,
            cert: pem
        }
    };

    tools.server(options)
        .use(function (req, res, next) {

            var mockData = mockMapper.getMockData(req.method, req.url, req.body);

            if (mockData !== null) {

                res.writeHead(mockData.status,
                    mockData.url && { 'Location': mockData.url },
                    !mockData.url && { 'Content-Type': 'application/json' }
                );

                res.end(mockData.body);

            } else {

                /* eslint no-console:0 */
                req.url.indexOf('/assets/') === -1 && console.log(req.url);

                next();
            }
        })
        .forward(/\/api\/v1\.0\/task\/(\d+)\/children/, function (matched) {

            return 'https://sandbox.yandex-team.ru:443/api/v1.0/task/' + matched[1] + '/children';
        })
        .forward(/\/api\/v1.0\/task/, function (matched) {

            return 'https://sandbox.yandex-team.ru:443' + (matched && matched.input);
        })
        .rewriteToIndex()
        .listen();
});

gulp.task('server-stop', function () {
    console.log(bs);
    bs && bs.stop();
});
