var injectify = require('injectify');

module.exports = function (config) {
    config.set({
        basePath: '',
        frameworks: [
            'browserify',
            'jasmine'
        ],
        files: [
            'dist/assets/**/js/vendor.js',
            'src/js/bootstrap.js',
            'src/js/**/*.spec.js'
        ],
        exclude: [],
        preprocessors: {
            'src/js/bootstrap.js': ['browserify'],
            'src/js/**/*.spec.js': ['browserify']
        },
        proxies: {
            '/api/': 'http://localhost.yandex-team.ru:9000/api/'
        },
        reporters: ['mocha'],
        port: 9876,
        colors: true,
        logLevel: config.LOG_WARN,
        autoWatch: false,
        browsers: ['PhantomJS'],
        captureTimeout: 60000,
        singleRun: true,
        plugins: [
            'karma-phantomjs-launcher',
            'karma-mocha-reporter',
            'karma-jasmine',
            'karma-browserify'
        ],
        browserify: {
            debug: true,
            extensions: ['.hbs'],
            transform: [
                [ injectify, {'global': true} ]
            ],
            // plugin: [
            //     proxyquire.plugin,
            //     [lessify, {
            //         selfSufficient: true,
            //         plugins: [scanner.createLessResolver()],
            //         paths: [
            //             __dirname + '/../../node_modules'
            //         ]
            //     }]
            // ]
        }
    });
};
