/**
 * Информация по определённым страницам
 */
const pages = {
    root: {
        title: 'Tasks | Sandbox',
        url: '/'
    },
    tasks: {
        title: 'Tasks | Sandbox',
        url: '/tasks'
    },
    resources: {
        title: 'Resources | Sandbox',
        url: '/resources'
    }
};

/**
 * Конфигурационные параметры для тестов:
 * – информация о страницах;
 * – блоки страниц
 */
module.exports = {
    options: {
        pendingTime: 80000
    },
    pages,
    blocks: {
        general: require('./page-blocks/general'),
        tasks: require('./page-blocks/tasks'),
        resources: require('./page-blocks/resources')
    }
};
