const assert = require('../chai/assert');
const generalBlocks = require('../../config').blocks.general;

module.exports = function (browser) {
    /**
     * Авторизуется с помощью переданного логина и пароля.
     * Текущий пользователь должен быть неавторизован.
     *
     * @param {String} username
     * @param {String} password
     * @returns {Client}
     */
    browser.addCommand('login', function (username, password) {
        return this
            .waitForAuth()
            .click(generalBlocks.authorization.loginLink)
            .setValue(generalBlocks.authorization.loginInput, username)
            .setValue(generalBlocks.authorization.passwordInput, password)
            .click(generalBlocks.authorization.submitButton);
    });

    /**
     * Разлогинивает пользователя.
     * Текущий пользователь должен быть авторизован.
     *
     * @returns {Client}
     */
    browser.addCommand('logout', function () {
        return this
            .waitForAuth()
            .click(generalBlocks.authorization.logoutLink)
            .click(generalBlocks.authorization.logoutApproveLink)
            .getText(generalBlocks.authorization.submitButton)
            .then(value => assert.equal(value, 'Log in'));
    });

    /**
     * Возвращает логин текущего пользователя.
     * Вернет пустую строку для неавторизованного пользователя.
     *
     * @returns {String}
     */
    browser.addCommand('getLogin', function () {
        return this
            .getAttribute(generalBlocks.user.avatar, 'title')
            .then(value => value);
    });

    /**
     * Проверяет, что текущий пользователь не авторизован (не залогинен).
     *
     * @returns {Client}
     */
    browser.addCommand('assertUserNotLoggedIn', function () {
        return this
            .getLogin()
            .then(login => assert.strictEqual(login, ''));
    });
};
