const config = require('../../config');
const generalBlocks = config.blocks.general;

module.exports = function (browser) {
    /**
     * Возвращает относительный путь открытой страницы.
     *
     * @returns {String}
     */
    browser.addCommand('getRelativeUrl', function () {
        return this
            .getUrl()
            .then((fullPath, tld) => {
                tld = '.' + (tld || 'ru') + '/';
                fullPath = fullPath.replace(/:\d+/g, '');

                const tldOffset = fullPath.indexOf(tld);

                return (tldOffset === -1) ?
                    fullPath :
                    fullPath.substr(tldOffset + tld.length - 1);
            });
    });

    /**
     * Ожидание рендера блока авторизации, который ведёт на `passport.yandex-team.ru` на сервисе.
     *
     * @returns {Client}
     */
    browser.addCommand('waitForAuth', function () {
        return this
            .waitForVisible(generalBlocks.loader.main, config.options.pendingTime, true)
            .click(generalBlocks.user.block)
            .waitForVisible(generalBlocks.authorization.loginLink, config.options.pendingTime);
    });
};
