const assert = require('../chai/assert');
const AUTH = require('dotenv').config({ silent: true });

const login = AUTH.LOGIN || process.env.LOGIN;
const password = AUTH.PASSWORD || process.env.PASSWORD;

module.exports = function (browser) {
    /**
     * Авторизовывает пользователя на сервисе.
     *
     * @returns {Client}
     */
    browser.addCommand('setUser', function () {
        return this.login(login, password);
    });

    /**
     * Возвращает идентификатор текущего авторизованного пользователя.
     *
     * @returns {String}
     */
    browser.addCommand('getUser', function () {
        return this
            .getLogin()
            .then(login => login);
    });

    /**
     * Проверяет, что пользователь авторизован.
     *
     * @returns {Client}
     */
    browser.addCommand('assertUser', function () {
        return this
            .getUser()
            .then(user => assert.strictEqual(login, user));
    });
};
