const chai = require('chai');
const assert = chai.assert;

/**
 * Batch-выполнение методов assert по конфигу
 *
 * @param {String} data – выполняем метод над этим массивом данных
 * @param {Object} configs – например {
 *      include: ['SANDBOX'],
 *      notInclude: ['TEST_TASK', 'evilj0e']
 * }
 */
assert.batch = (data, configs) => {
    Object.keys(configs).forEach(key => {
        const values = configs[key];

        values.forEach(value => assert[key](data, value));
    });
};

module.exports = assert;
