/**
 * Массив сопоставлений GET-ручек и json-ноков, которые будут замоканы
 */
module.exports = [

    // User
    {
        method: 'GET',
        url: /\/api\/v1.0\/user\/current\/?$/,
        data: require('./user/current.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/user\/current\/groups\/?$/,
        data: require('./user/current/groups.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/user\/current\/preferences\/prefs\/?$/,
        data: require('./user/current/preferences/prefs.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/user\/current\/preferences\/task-list-last-filter\/?$/,
        data: require('./user/current/preferences/task-list-last-filter.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/user\/current\/preferences\/task-list\/?$/,
        data: require('./user/current/preferences/task-list.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/user\/current\/preferences\/service-notifications\/?$/,
        data: require('./user/current/preferences/service-notifications.json')
    },

    // Vault
    {
        method: 'GET',
        url: /\/api\/v1.0\/vault\/(\d+)\/?/i,
        data: require('./vault/id.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/vault\/?/i,
        data: require('./vault.json')
    },

    // Suggest
    {
        method: 'GET',
        url: /\/api\/v1.0\/suggest\/group\/?$/,
        data: require('./suggest/group.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/suggest\/resource\/?$/,
        data: require('./suggest/resource.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/suggest\/task\/?$/,
        data: require('./suggest/task.json')
    },
    {
        method: 'GET',
        url: /\/api\/v1.0\/suggest\/client\/?$/,
        data: require('./suggest/client.json')
    },

    // Service
    {
        method: 'GET',
        url: /\/api\/v1.0\/service\/ui\/notification\/?$/,
        data: require('./service/ui/notification.json')
    }
];
