var _ = require('../../vendor/lodash/dist/lodash.underscore');

var tasks = {

    status : 200,
    body   : {
        skipped: 0,
        total: 156,
        limit: 20,
        items: [
            {
                id: 16816482,
                platform: 'freebsd',
                important: true,
                status: 'EXECUTING',
                type: 'VERTICAL_TEST_WRAPPER_1',
                weather: 3, // scores in range [1..10]
                description: 'test_working',
                time: {
                    created: '2014-08-15T19:02:38.551Z',
                    updated: '2014-08-15T19:08:28.551Z'
                },
                execution: {  // seconds
                    current: 394,
                    estimated: 421,
                    action: 'Что сейчас происходит'
                },
                owner: 'ANTISPAM-ROBOT',
                priority: {
                    class: 'USER',
                    subclass: 'HIGH'
                }
            },
            {
                id: 1810987,
                platform: 'any',
                important: false,
                status: 'EXECUTING',
                type: 'VERTICAL_TEST_WRAPPER_1',
                weather: 7, // scores in range [1..10]
                description: 'test_working',
                time: {
                    created: '2014-07-31T10:54:28.551Z',
                    updated: '2014-07-31T10:55:28.551Z'
                },
                execution: {  // seconds
                    current: 394,
                    estimated: 1945,
                    action: 'Что сейчас происходит'
                },
                owner: 'AUTOCHECK',
                priority: {
                    class: 'USER',
                    subclass: 'HIGH'
                }
            },
            {
                id: 16811111,
                platform: 'linux',
                important: false,
                status: 'FINISHED',
                type: 'VERTICAL_TEST_WRAPPER_1',
                weather: 2, // scores in range [1..10]
                description: 'freshclient',
                time: {
                    created: '2014-08-15T19:15:28.551Z',
                    updated: '2014-08-15T19:18:28.551Z'
                },
                owner: 'AUTOCHECK',
                priority: {
                    class: 'USER',
                    subclass: 'NORMAL'
                }
            },
            {
                id: 16816494,
                platform: 'any',
                important: false,
                status: 'WAIT_CHILD',
                type: 'BUILD_KIWI_TESTS_COMMON',
                weather: 1, // scores in range [1..10]
                description: 'we_touch_phone#124398721098379827435987',
                time: {
                    created: '2014-07-31T11:54:28.551Z',
                    updated: '2014-07-31T12:55:28.551Z'
                },
                children: {
                    16812837: 'WAIT_CHILD',
                    16812838: 'WAIT_CHILD',
                    16812839: 'WAIT_CHILD',
                    16812867: 'WAIT_CHILD',
                    16812868: 'FINISHED',
                    16812870: 'FAILURE'
                },
                owner: 'GEOSEARCH-ROBOT',
                priority: {
                    class: 'SERVICE',
                    subclass: 'LOW'
                }
            },
            {
                id: 16882582,
                platform: 'any',
                important: true,
                status: 'EXECUTING',
                type: 'VERTICAL_TEST_WRAPPER_1',
                weather: 8, // scores in range [1..10]
                description: 'test_working',
                time: {
                    created: '2014-07-31T13:41:28.551Z',
                    updated: '2014-07-31T13:55:28.551Z'
                },
                execution: {  // seconds
                    current: 105,
                    estimated: 452,
                    action: 'Что сейчас происходит'
                },
                owner: 'ANTISPAM-ROBOT',
                priority: {
                    class: 'BACKGROUND',
                    subclass: 'HIGH'
                }
            },
            {
                id: 16845672,
                platform: 'linux',
                important: true,
                status: 'EXECUTING',
                type: 'VERTICAL_TEST_WRAPPER_1',
                weather: 5, // scores in range [1..10]
                description: 'test_working',
                time: {
                    created: '2014-07-31T10:32:28.551Z',
                    updated: '2014-07-31T10:48:28.551Z'
                },
                execution: {  // seconds
                    current: 225,
                    estimated: 657,
                    action: 'Что сейчас происходит'
                },
                owner: 'GEOSEARCH-ROBOT',
                priority: {
                    class: 'BACKGROUND',
                    subclass: 'LOW'
                }
            },
            {
                id: 138562,
                platform: 'linux',
                important: true,
                status: 'EXECUTING',
                type: 'VERTICAL_TEST_WRAPPER_1',
                weather: 9, // scores in range [1..10]
                description: 'test_working',
                time: {
                    created: '2014-07-31T11:19:28.551Z',
                    updated: '2014-07-31T11:56:28.551Z'
                },
                execution: {  // seconds
                    current: 987,
                    estimated: 354,
                    action: 'Что сейчас происходит'
                },
                owner: 'GEOSEARCH-ROBOT',
                priority: {
                    class: 'SERVICE',
                    subclass: 'NORMAL'
                }
            }
        ]
    },

    processor : function(urlParts, reqBody, mockedData, status){

        var data = mockedData,
            limit = parseInt(urlParts[1], 10),
            offset = parseInt(urlParts[2], 10),
            page = offset / limit + 1,
            order = urlParts[3] ? urlParts[3].slice(1) : null,
            dir = urlParts[3] ? urlParts[3].slice(0, 1) : null,
            id;


        /*if(page) {
            for (var q = 0; q < data.items.length; q++) {

                id = String(data.items[q].id);
                data.items[q].id = parseInt(id.replace(/\d$/i, page), 10);
            }
        }*/

        data.items = (order !== null ? (dir === '-' ? _.sortBy(data.items, order).reverse() : _.sortBy(data.items, order)) : _.shuffle(data.items));
        data.limit = (limit ? limit : data.limit);
        data.skipped = (offset ? offset : 0);

        return {
            status : status,
            body   : data
        };
    }
};


module.exports = tasks;
