/**
 * Все ручки, которые будут замоканы
 */
const map = [
    require('./GET/list'),
    require('./PUT/list')
];

const mockMapper = {

    /**
     * Получает ноки по методу и ручке
     *
     * @param {String} method
     * @param {String} mockedURL
     */
    getMockData(method, mockedURL) {
        /* eslint complexity: [1, 7] */

        let parts = null;

        for (let i = 0; i < map.length; i++) {
            const mock = map[i];

            for (let j = 0; j < mock.length; j++) {
                parts = mock[j].url.exec(decodeURIComponent(mockedURL));

                if (parts !== null && mock[j].method === method) {
                    // Console.log('SANDBOX: URI is mocked: ' + method + ' | ' + mockedURL);

                    return {
                        url: mockedURL,
                        body: JSON.stringify(mock[j].data),
                        status: mock[j].status || (mock[j].data ? 200 : 500)
                    };
                }
            }
        }

        return null;
    }
};

module.exports = mockMapper;
